/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.BaseScriptData;

public class ForgeScriptData
extends BaseScriptData {
    @Override
    public ITextComponent noticeString(String type, Object event) {
        TextComponentString message = new TextComponentString("Forge Scripts ");
        message.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return message.func_150257_a(super.noticeString(type, event));
    }

    @Override
    public void runScript(String type, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            CustomNpcs.Server.func_152344_a(() -> {
                if (ScriptController.Instance.lastLoaded > this.lastInited) {
                    this.lastInited = ScriptController.Instance.lastLoaded;
                    if (!type.equalsIgnoreCase(EnumScriptType.INIT.function)) {
                        EventHooks.onForgeInit(this);
                    }
                }
                for (ScriptContainer script : this.scripts) {
                    script.run(type, event);
                }
            });
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        EventHooks.onForgeInit(this);
    }
}

